#include <iostream>
#include <algorithm>

using namespace std;

int const LIM = 1010;

int n, m, q;
long long cur[LIM], mask[LIM];
bool state[LIM][LIM];

long long invert(long long x) {
    long long result = 0;
    for (int i = 0; i < n; ++i) {
        if (!((x >> i) & 1)) {
            result |= (1ll << i);
        }
    }
    return result;
}

int main() {
    ios_base::sync_with_stdio(false);
    string s;
    while (cin >> n >> m >> q) {
        if (n == 0 && m == 0 && q == 0)
            break;
        for (int i = 0; i < q; ++i) {
            cin >> s;
            cur[i] = 0;
            for (int k = 0; k < (int) s.length(); ++k) {
                if (s[k] == '1') {
                    cur[i] |= (1ll << k);
                }
            }
            cin >> s;
            for (int k = 0; k < (int) s.length(); ++k) {
                if (s[k] == '1') {
                    state[i][k] = true;
                } else {
                    state[i][k] = false;
                }
            }
        }
        for (int i = 1; i < q; ++i) {
            cur[i] ^= cur[i - 1];
        }
        for (int i = 0; i < m; ++i) {
            mask[i] = (1ll << n) - 1;
        }
        for (int i = 0; i < q; ++i) {
            for (int k = 0; k < m; ++k) {
                if (state[i][k]) {
                    mask[k] &= cur[i];
                } else {
                    mask[k] &= invert(cur[i]);
                }
            }
        }
        for (int i = 0; i < m; ++i) {
            char c = 0;
            for (int j = 0; j < n; ++j) {
                if ((mask[i] >> j) & 1ll) {
                    if (c != 0) {
                        c = '?';
                        break;
                    } else if (j <= '9' - '0') {
                        c = '0' + j;
                    } else {
                        c = 'A' + j - 10;
                    }
                }
            }
            cout << c;
        }
        cout << '\n';
    }
    return 0;
}
